/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.json.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.AbstractStreamDecoder;
import jakarta.json.JsonNumber;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JsonParserDecoder
extends AbstractStreamDecoder {
    private final JsonParser jsonParser;
    private JsonParser.Event currentEvent;

    public JsonParserDecoder(JsonParser jsonParser) {
        this(jsonParser, DEFAULT_LIMITS);
    }

    @Internal
    JsonParserDecoder(JsonParser jsonParser, LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
        this.jsonParser = jsonParser;
        this.currentEvent = jsonParser.next();
    }

    public void finishStructure(boolean consumeLeftElements) throws IOException {
        super.finishStructure(consumeLeftElements);
        this.nextToken();
    }

    protected AbstractStreamDecoder.TokenType currentToken() {
        return switch (this.currentEvent) {
            case JsonParser.Event.START_ARRAY -> AbstractStreamDecoder.TokenType.START_ARRAY;
            case JsonParser.Event.START_OBJECT -> AbstractStreamDecoder.TokenType.START_OBJECT;
            case JsonParser.Event.KEY_NAME -> AbstractStreamDecoder.TokenType.KEY;
            case JsonParser.Event.VALUE_STRING -> AbstractStreamDecoder.TokenType.STRING;
            case JsonParser.Event.VALUE_NUMBER -> AbstractStreamDecoder.TokenType.NUMBER;
            case JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_FALSE -> AbstractStreamDecoder.TokenType.BOOLEAN;
            case JsonParser.Event.VALUE_NULL -> AbstractStreamDecoder.TokenType.NULL;
            case JsonParser.Event.END_OBJECT -> AbstractStreamDecoder.TokenType.END_OBJECT;
            case JsonParser.Event.END_ARRAY -> AbstractStreamDecoder.TokenType.END_ARRAY;
            default -> AbstractStreamDecoder.TokenType.OTHER;
        };
    }

    protected void nextToken() {
        this.currentEvent = this.jsonParser.hasNext() ? this.jsonParser.next() : null;
    }

    protected String getCurrentKey() {
        return this.jsonParser.getString();
    }

    protected String coerceScalarToString(AbstractStreamDecoder.TokenType currentToken) {
        return switch (this.currentEvent) {
            case JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER -> this.jsonParser.getString();
            case JsonParser.Event.VALUE_TRUE -> "true";
            case JsonParser.Event.VALUE_FALSE -> "false";
            default -> throw new IllegalStateException("Method called in wrong context " + String.valueOf(this.currentEvent));
        };
    }

    protected String getString() {
        return this.jsonParser.getString();
    }

    protected boolean getBoolean() {
        return this.currentEvent == JsonParser.Event.VALUE_TRUE;
    }

    protected long getLong() {
        return this.jsonParser.getLong();
    }

    protected double getDouble() {
        return this.jsonParser.getBigDecimal().doubleValue();
    }

    protected BigInteger getBigInteger() {
        return this.jsonParser.getBigDecimal().toBigInteger();
    }

    protected BigDecimal getBigDecimal() {
        return this.jsonParser.getBigDecimal();
    }

    protected Number getBestNumber() {
        return ((JsonNumber)this.jsonParser.getValue()).numberValue();
    }

    protected void skipChildren() {
        if (this.currentEvent == JsonParser.Event.START_OBJECT) {
            this.jsonParser.skipObject();
        } else if (this.currentEvent == JsonParser.Event.START_ARRAY) {
            this.jsonParser.skipArray();
        }
    }

    public IOException createDeserializationException(String message, Object invalidValue) {
        return new SerdeException(message + " \n at " + String.valueOf(this.jsonParser.getLocation()));
    }
}

