/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.zpr;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.zpr.ZprAsyncClient;
import com.oracle.bmc.zpr.requests.CreateConfigurationRequest;
import com.oracle.bmc.zpr.requests.CreateZprPolicyRequest;
import com.oracle.bmc.zpr.requests.DeleteZprPolicyRequest;
import com.oracle.bmc.zpr.requests.GetConfigurationRequest;
import com.oracle.bmc.zpr.requests.GetZprConfigurationWorkRequestRequest;
import com.oracle.bmc.zpr.requests.GetZprPolicyRequest;
import com.oracle.bmc.zpr.requests.GetZprPolicyWorkRequestRequest;
import com.oracle.bmc.zpr.requests.ListZprConfigurationWorkRequestErrorsRequest;
import com.oracle.bmc.zpr.requests.ListZprConfigurationWorkRequestLogsRequest;
import com.oracle.bmc.zpr.requests.ListZprConfigurationWorkRequestsRequest;
import com.oracle.bmc.zpr.requests.ListZprPoliciesRequest;
import com.oracle.bmc.zpr.requests.ListZprPolicyWorkRequestErrorsRequest;
import com.oracle.bmc.zpr.requests.ListZprPolicyWorkRequestLogsRequest;
import com.oracle.bmc.zpr.requests.ListZprPolicyWorkRequestsRequest;
import com.oracle.bmc.zpr.requests.UpdateZprPolicyRequest;
import com.oracle.bmc.zpr.responses.CreateConfigurationResponse;
import com.oracle.bmc.zpr.responses.CreateZprPolicyResponse;
import com.oracle.bmc.zpr.responses.DeleteZprPolicyResponse;
import com.oracle.bmc.zpr.responses.GetConfigurationResponse;
import com.oracle.bmc.zpr.responses.GetZprConfigurationWorkRequestResponse;
import com.oracle.bmc.zpr.responses.GetZprPolicyResponse;
import com.oracle.bmc.zpr.responses.GetZprPolicyWorkRequestResponse;
import com.oracle.bmc.zpr.responses.ListZprConfigurationWorkRequestErrorsResponse;
import com.oracle.bmc.zpr.responses.ListZprConfigurationWorkRequestLogsResponse;
import com.oracle.bmc.zpr.responses.ListZprConfigurationWorkRequestsResponse;
import com.oracle.bmc.zpr.responses.ListZprPoliciesResponse;
import com.oracle.bmc.zpr.responses.ListZprPolicyWorkRequestErrorsResponse;
import com.oracle.bmc.zpr.responses.ListZprPolicyWorkRequestLogsResponse;
import com.oracle.bmc.zpr.responses.ListZprPolicyWorkRequestsResponse;
import com.oracle.bmc.zpr.responses.UpdateZprPolicyResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ZprAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ZprRxClient {
    ZprAsyncClient client;

    ZprRxClient(ZprAsyncClient client) {
        this.client = client;
    }

    public Single<CreateConfigurationResponse> createConfiguration(CreateConfigurationRequest request) {
        return Single.create(emitter -> this.client.createConfiguration(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateZprPolicyResponse> createZprPolicy(CreateZprPolicyRequest request) {
        return Single.create(emitter -> this.client.createZprPolicy(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteZprPolicyResponse> deleteZprPolicy(DeleteZprPolicyRequest request) {
        return Single.create(emitter -> this.client.deleteZprPolicy(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request) {
        return Single.create(emitter -> this.client.getConfiguration(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetZprConfigurationWorkRequestResponse> getZprConfigurationWorkRequest(GetZprConfigurationWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getZprConfigurationWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetZprPolicyResponse> getZprPolicy(GetZprPolicyRequest request) {
        return Single.create(emitter -> this.client.getZprPolicy(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetZprPolicyWorkRequestResponse> getZprPolicyWorkRequest(GetZprPolicyWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getZprPolicyWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListZprConfigurationWorkRequestErrorsResponse> listZprConfigurationWorkRequestErrors(ListZprConfigurationWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listZprConfigurationWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListZprConfigurationWorkRequestLogsResponse> listZprConfigurationWorkRequestLogs(ListZprConfigurationWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listZprConfigurationWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListZprConfigurationWorkRequestsResponse> listZprConfigurationWorkRequests(ListZprConfigurationWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listZprConfigurationWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListZprPoliciesResponse> listZprPolicies(ListZprPoliciesRequest request) {
        return Single.create(emitter -> this.client.listZprPolicies(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListZprPolicyWorkRequestErrorsResponse> listZprPolicyWorkRequestErrors(ListZprPolicyWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listZprPolicyWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListZprPolicyWorkRequestLogsResponse> listZprPolicyWorkRequestLogs(ListZprPolicyWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listZprPolicyWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListZprPolicyWorkRequestsResponse> listZprPolicyWorkRequests(ListZprPolicyWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listZprPolicyWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateZprPolicyResponse> updateZprPolicy(UpdateZprPolicyRequest request) {
        return Single.create(emitter -> this.client.updateZprPolicy(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

