/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.vault;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.vault.VaultsAsyncClient;
import com.oracle.bmc.vault.requests.CancelSecretDeletionRequest;
import com.oracle.bmc.vault.requests.CancelSecretRotationRequest;
import com.oracle.bmc.vault.requests.CancelSecretVersionDeletionRequest;
import com.oracle.bmc.vault.requests.ChangeSecretCompartmentRequest;
import com.oracle.bmc.vault.requests.CreateSecretRequest;
import com.oracle.bmc.vault.requests.GetSecretRequest;
import com.oracle.bmc.vault.requests.GetSecretVersionRequest;
import com.oracle.bmc.vault.requests.ListSecretVersionsRequest;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.requests.RotateSecretRequest;
import com.oracle.bmc.vault.requests.ScheduleSecretDeletionRequest;
import com.oracle.bmc.vault.requests.ScheduleSecretVersionDeletionRequest;
import com.oracle.bmc.vault.requests.UpdateSecretRequest;
import com.oracle.bmc.vault.responses.CancelSecretDeletionResponse;
import com.oracle.bmc.vault.responses.CancelSecretRotationResponse;
import com.oracle.bmc.vault.responses.CancelSecretVersionDeletionResponse;
import com.oracle.bmc.vault.responses.ChangeSecretCompartmentResponse;
import com.oracle.bmc.vault.responses.CreateSecretResponse;
import com.oracle.bmc.vault.responses.GetSecretResponse;
import com.oracle.bmc.vault.responses.GetSecretVersionResponse;
import com.oracle.bmc.vault.responses.ListSecretVersionsResponse;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import com.oracle.bmc.vault.responses.RotateSecretResponse;
import com.oracle.bmc.vault.responses.ScheduleSecretDeletionResponse;
import com.oracle.bmc.vault.responses.ScheduleSecretVersionDeletionResponse;
import com.oracle.bmc.vault.responses.UpdateSecretResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={VaultsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class VaultsRxClient {
    VaultsAsyncClient client;

    VaultsRxClient(VaultsAsyncClient client) {
        this.client = client;
    }

    public Single<CancelSecretDeletionResponse> cancelSecretDeletion(CancelSecretDeletionRequest request) {
        return Single.create(emitter -> this.client.cancelSecretDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CancelSecretRotationResponse> cancelSecretRotation(CancelSecretRotationRequest request) {
        return Single.create(emitter -> this.client.cancelSecretRotation(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CancelSecretVersionDeletionResponse> cancelSecretVersionDeletion(CancelSecretVersionDeletionRequest request) {
        return Single.create(emitter -> this.client.cancelSecretVersionDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeSecretCompartmentResponse> changeSecretCompartment(ChangeSecretCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeSecretCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateSecretResponse> createSecret(CreateSecretRequest request) {
        return Single.create(emitter -> this.client.createSecret(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSecretResponse> getSecret(GetSecretRequest request) {
        return Single.create(emitter -> this.client.getSecret(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSecretVersionResponse> getSecretVersion(GetSecretVersionRequest request) {
        return Single.create(emitter -> this.client.getSecretVersion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSecretVersionsResponse> listSecretVersions(ListSecretVersionsRequest request) {
        return Single.create(emitter -> this.client.listSecretVersions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSecretsResponse> listSecrets(ListSecretsRequest request) {
        return Single.create(emitter -> this.client.listSecrets(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RotateSecretResponse> rotateSecret(RotateSecretRequest request) {
        return Single.create(emitter -> this.client.rotateSecret(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ScheduleSecretDeletionResponse> scheduleSecretDeletion(ScheduleSecretDeletionRequest request) {
        return Single.create(emitter -> this.client.scheduleSecretDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ScheduleSecretVersionDeletionResponse> scheduleSecretVersionDeletion(ScheduleSecretVersionDeletionRequest request) {
        return Single.create(emitter -> this.client.scheduleSecretVersionDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateSecretResponse> updateSecret(UpdateSecretRequest request) {
        return Single.create(emitter -> this.client.updateSecret(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

