/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.tenantmanagercontrolplane;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.SubscriptionAsyncClient;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateSubscriptionMappingRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteSubscriptionMappingRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetAssignedSubscriptionRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetSubscriptionMappingRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetSubscriptionRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListAssignedSubscriptionLineItemsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListAssignedSubscriptionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListAvailableRegionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSubscriptionLineItemsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSubscriptionMappingsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSubscriptionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateSubscriptionMappingResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteSubscriptionMappingResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetAssignedSubscriptionResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetSubscriptionMappingResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetSubscriptionResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListAssignedSubscriptionLineItemsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListAssignedSubscriptionsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListAvailableRegionsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSubscriptionLineItemsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSubscriptionMappingsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSubscriptionsResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={SubscriptionAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class SubscriptionRxClient {
    SubscriptionAsyncClient client;

    SubscriptionRxClient(SubscriptionAsyncClient client) {
        this.client = client;
    }

    public Single<CreateSubscriptionMappingResponse> createSubscriptionMapping(CreateSubscriptionMappingRequest request) {
        return Single.create(emitter -> this.client.createSubscriptionMapping(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteSubscriptionMappingResponse> deleteSubscriptionMapping(DeleteSubscriptionMappingRequest request) {
        return Single.create(emitter -> this.client.deleteSubscriptionMapping(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAssignedSubscriptionResponse> getAssignedSubscription(GetAssignedSubscriptionRequest request) {
        return Single.create(emitter -> this.client.getAssignedSubscription(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSubscriptionResponse> getSubscription(GetSubscriptionRequest request) {
        return Single.create(emitter -> this.client.getSubscription(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSubscriptionMappingResponse> getSubscriptionMapping(GetSubscriptionMappingRequest request) {
        return Single.create(emitter -> this.client.getSubscriptionMapping(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAssignedSubscriptionLineItemsResponse> listAssignedSubscriptionLineItems(ListAssignedSubscriptionLineItemsRequest request) {
        return Single.create(emitter -> this.client.listAssignedSubscriptionLineItems(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAssignedSubscriptionsResponse> listAssignedSubscriptions(ListAssignedSubscriptionsRequest request) {
        return Single.create(emitter -> this.client.listAssignedSubscriptions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAvailableRegionsResponse> listAvailableRegions(ListAvailableRegionsRequest request) {
        return Single.create(emitter -> this.client.listAvailableRegions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSubscriptionLineItemsResponse> listSubscriptionLineItems(ListSubscriptionLineItemsRequest request) {
        return Single.create(emitter -> this.client.listSubscriptionLineItems(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSubscriptionMappingsResponse> listSubscriptionMappings(ListSubscriptionMappingsRequest request) {
        return Single.create(emitter -> this.client.listSubscriptionMappings(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest request) {
        return Single.create(emitter -> this.client.listSubscriptions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

