/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.tenantmanagercontrolplane;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.OrganizationAsyncClient;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ApproveOrganizationTenancyForTransferRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateChildTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteOrganizationTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetOrganizationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetOrganizationTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListOrganizationTenanciesRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListOrganizationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.RestoreOrganizationTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UnapproveOrganizationTenancyForTransferRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateOrganizationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ApproveOrganizationTenancyForTransferResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateChildTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteOrganizationTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetOrganizationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetOrganizationTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListOrganizationTenanciesResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListOrganizationsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.RestoreOrganizationTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UnapproveOrganizationTenancyForTransferResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateOrganizationResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={OrganizationAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OrganizationRxClient {
    OrganizationAsyncClient client;

    OrganizationRxClient(OrganizationAsyncClient client) {
        this.client = client;
    }

    public Single<ApproveOrganizationTenancyForTransferResponse> approveOrganizationTenancyForTransfer(ApproveOrganizationTenancyForTransferRequest request) {
        return Single.create(emitter -> this.client.approveOrganizationTenancyForTransfer(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateChildTenancyResponse> createChildTenancy(CreateChildTenancyRequest request) {
        return Single.create(emitter -> this.client.createChildTenancy(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteOrganizationTenancyResponse> deleteOrganizationTenancy(DeleteOrganizationTenancyRequest request) {
        return Single.create(emitter -> this.client.deleteOrganizationTenancy(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetOrganizationResponse> getOrganization(GetOrganizationRequest request) {
        return Single.create(emitter -> this.client.getOrganization(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetOrganizationTenancyResponse> getOrganizationTenancy(GetOrganizationTenancyRequest request) {
        return Single.create(emitter -> this.client.getOrganizationTenancy(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListOrganizationTenanciesResponse> listOrganizationTenancies(ListOrganizationTenanciesRequest request) {
        return Single.create(emitter -> this.client.listOrganizationTenancies(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListOrganizationsResponse> listOrganizations(ListOrganizationsRequest request) {
        return Single.create(emitter -> this.client.listOrganizations(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RestoreOrganizationTenancyResponse> restoreOrganizationTenancy(RestoreOrganizationTenancyRequest request) {
        return Single.create(emitter -> this.client.restoreOrganizationTenancy(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UnapproveOrganizationTenancyForTransferResponse> unapproveOrganizationTenancyForTransfer(UnapproveOrganizationTenancyForTransferRequest request) {
        return Single.create(emitter -> this.client.unapproveOrganizationTenancyForTransfer(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateOrganizationResponse> updateOrganization(UpdateOrganizationRequest request) {
        return Single.create(emitter -> this.client.updateOrganization(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

