/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.tenantmanagercontrolplane;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.GovernanceAsyncClient;
import com.oracle.bmc.tenantmanagercontrolplane.requests.AddGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.RemoveGovernanceRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.AddGovernanceResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.RemoveGovernanceResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={GovernanceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class GovernanceRxClient {
    GovernanceAsyncClient client;

    GovernanceRxClient(GovernanceAsyncClient client) {
        this.client = client;
    }

    public Single<AddGovernanceResponse> addGovernance(AddGovernanceRequest request) {
        return Single.create(emitter -> this.client.addGovernance(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RemoveGovernanceResponse> removeGovernance(RemoveGovernanceRequest request) {
        return Single.create(emitter -> this.client.removeGovernance(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

