/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.streaming;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.streaming.StreamAsyncClient;
import com.oracle.bmc.streaming.requests.ConsumerCommitRequest;
import com.oracle.bmc.streaming.requests.ConsumerHeartbeatRequest;
import com.oracle.bmc.streaming.requests.CreateCursorRequest;
import com.oracle.bmc.streaming.requests.CreateGroupCursorRequest;
import com.oracle.bmc.streaming.requests.GetGroupRequest;
import com.oracle.bmc.streaming.requests.GetMessagesRequest;
import com.oracle.bmc.streaming.requests.PutMessagesRequest;
import com.oracle.bmc.streaming.requests.UpdateGroupRequest;
import com.oracle.bmc.streaming.responses.ConsumerCommitResponse;
import com.oracle.bmc.streaming.responses.ConsumerHeartbeatResponse;
import com.oracle.bmc.streaming.responses.CreateCursorResponse;
import com.oracle.bmc.streaming.responses.CreateGroupCursorResponse;
import com.oracle.bmc.streaming.responses.GetGroupResponse;
import com.oracle.bmc.streaming.responses.GetMessagesResponse;
import com.oracle.bmc.streaming.responses.PutMessagesResponse;
import com.oracle.bmc.streaming.responses.UpdateGroupResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={StreamAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class StreamRxClient {
    StreamAsyncClient client;

    StreamRxClient(StreamAsyncClient client) {
        this.client = client;
    }

    public Single<ConsumerCommitResponse> consumerCommit(ConsumerCommitRequest request) {
        return Single.create(emitter -> this.client.consumerCommit(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ConsumerHeartbeatResponse> consumerHeartbeat(ConsumerHeartbeatRequest request) {
        return Single.create(emitter -> this.client.consumerHeartbeat(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateCursorResponse> createCursor(CreateCursorRequest request) {
        return Single.create(emitter -> this.client.createCursor(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateGroupCursorResponse> createGroupCursor(CreateGroupCursorRequest request) {
        return Single.create(emitter -> this.client.createGroupCursor(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetGroupResponse> getGroup(GetGroupRequest request) {
        return Single.create(emitter -> this.client.getGroup(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetMessagesResponse> getMessages(GetMessagesRequest request) {
        return Single.create(emitter -> this.client.getMessages(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<PutMessagesResponse> putMessages(PutMessagesRequest request) {
        return Single.create(emitter -> this.client.putMessages(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateGroupResponse> updateGroup(UpdateGroupRequest request) {
        return Single.create(emitter -> this.client.updateGroup(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

