/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.operatoraccesscontrol;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.operatoraccesscontrol.AccessRequestsAsyncClient;
import com.oracle.bmc.operatoraccesscontrol.requests.ApproveAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.GetAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.GetAuditLogReportRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.InteractionRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListAccessRequestHistoriesRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListAccessRequestsRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListInteractionsRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.RejectAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ReviewAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.RevokeAccessRequestRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.ApproveAccessRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.GetAccessRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.GetAuditLogReportResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.InteractionRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListAccessRequestHistoriesResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListAccessRequestsResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListInteractionsResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.RejectAccessRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ReviewAccessRequestResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.RevokeAccessRequestResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={AccessRequestsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AccessRequestsRxClient {
    AccessRequestsAsyncClient client;

    AccessRequestsRxClient(AccessRequestsAsyncClient client) {
        this.client = client;
    }

    public Single<ApproveAccessRequestResponse> approveAccessRequest(ApproveAccessRequestRequest request) {
        return Single.create(emitter -> this.client.approveAccessRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAccessRequestResponse> getAccessRequest(GetAccessRequestRequest request) {
        return Single.create(emitter -> this.client.getAccessRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAuditLogReportResponse> getAuditLogReport(GetAuditLogReportRequest request) {
        return Single.create(emitter -> this.client.getAuditLogReport(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<InteractionRequestResponse> interactionRequest(InteractionRequestRequest request) {
        return Single.create(emitter -> this.client.interactionRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAccessRequestHistoriesResponse> listAccessRequestHistories(ListAccessRequestHistoriesRequest request) {
        return Single.create(emitter -> this.client.listAccessRequestHistories(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAccessRequestsResponse> listAccessRequests(ListAccessRequestsRequest request) {
        return Single.create(emitter -> this.client.listAccessRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListInteractionsResponse> listInteractions(ListInteractionsRequest request) {
        return Single.create(emitter -> this.client.listInteractions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RejectAccessRequestResponse> rejectAccessRequest(RejectAccessRequestRequest request) {
        return Single.create(emitter -> this.client.rejectAccessRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ReviewAccessRequestResponse> reviewAccessRequest(ReviewAccessRequestRequest request) {
        return Single.create(emitter -> this.client.reviewAccessRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RevokeAccessRequestResponse> revokeAccessRequest(RevokeAccessRequestRequest request) {
        return Single.create(emitter -> this.client.revokeAccessRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

