/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.oda;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.oda.OdapackageAsyncClient;
import com.oracle.bmc.oda.requests.CreateImportedPackageRequest;
import com.oracle.bmc.oda.requests.DeleteImportedPackageRequest;
import com.oracle.bmc.oda.requests.GetImportedPackageRequest;
import com.oracle.bmc.oda.requests.GetPackageRequest;
import com.oracle.bmc.oda.requests.ListImportedPackagesRequest;
import com.oracle.bmc.oda.requests.ListPackagesRequest;
import com.oracle.bmc.oda.requests.UpdateImportedPackageRequest;
import com.oracle.bmc.oda.responses.CreateImportedPackageResponse;
import com.oracle.bmc.oda.responses.DeleteImportedPackageResponse;
import com.oracle.bmc.oda.responses.GetImportedPackageResponse;
import com.oracle.bmc.oda.responses.GetPackageResponse;
import com.oracle.bmc.oda.responses.ListImportedPackagesResponse;
import com.oracle.bmc.oda.responses.ListPackagesResponse;
import com.oracle.bmc.oda.responses.UpdateImportedPackageResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={OdapackageAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OdapackageRxClient {
    OdapackageAsyncClient client;

    OdapackageRxClient(OdapackageAsyncClient client) {
        this.client = client;
    }

    public Single<CreateImportedPackageResponse> createImportedPackage(CreateImportedPackageRequest request) {
        return Single.create(emitter -> this.client.createImportedPackage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteImportedPackageResponse> deleteImportedPackage(DeleteImportedPackageRequest request) {
        return Single.create(emitter -> this.client.deleteImportedPackage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetImportedPackageResponse> getImportedPackage(GetImportedPackageRequest request) {
        return Single.create(emitter -> this.client.getImportedPackage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetPackageResponse> getPackage(GetPackageRequest request) {
        return Single.create(emitter -> this.client.getPackage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListImportedPackagesResponse> listImportedPackages(ListImportedPackagesRequest request) {
        return Single.create(emitter -> this.client.listImportedPackages(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListPackagesResponse> listPackages(ListPackagesRequest request) {
        return Single.create(emitter -> this.client.listPackages(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateImportedPackageResponse> updateImportedPackage(UpdateImportedPackageRequest request) {
        return Single.create(emitter -> this.client.updateImportedPackage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

