/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.monitoring;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.monitoring.MonitoringAsyncClient;
import com.oracle.bmc.monitoring.requests.ChangeAlarmCompartmentRequest;
import com.oracle.bmc.monitoring.requests.CreateAlarmRequest;
import com.oracle.bmc.monitoring.requests.CreateAlarmSuppressionRequest;
import com.oracle.bmc.monitoring.requests.DeleteAlarmRequest;
import com.oracle.bmc.monitoring.requests.DeleteAlarmSuppressionRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmHistoryRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmSuppressionRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmSuppressionsRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsStatusRequest;
import com.oracle.bmc.monitoring.requests.ListMetricsRequest;
import com.oracle.bmc.monitoring.requests.PostMetricDataRequest;
import com.oracle.bmc.monitoring.requests.RemoveAlarmSuppressionRequest;
import com.oracle.bmc.monitoring.requests.RetrieveDimensionStatesRequest;
import com.oracle.bmc.monitoring.requests.SummarizeAlarmSuppressionHistoryRequest;
import com.oracle.bmc.monitoring.requests.SummarizeMetricsDataRequest;
import com.oracle.bmc.monitoring.requests.UpdateAlarmRequest;
import com.oracle.bmc.monitoring.responses.ChangeAlarmCompartmentResponse;
import com.oracle.bmc.monitoring.responses.CreateAlarmResponse;
import com.oracle.bmc.monitoring.responses.CreateAlarmSuppressionResponse;
import com.oracle.bmc.monitoring.responses.DeleteAlarmResponse;
import com.oracle.bmc.monitoring.responses.DeleteAlarmSuppressionResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmHistoryResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmSuppressionResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmSuppressionsResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsStatusResponse;
import com.oracle.bmc.monitoring.responses.ListMetricsResponse;
import com.oracle.bmc.monitoring.responses.PostMetricDataResponse;
import com.oracle.bmc.monitoring.responses.RemoveAlarmSuppressionResponse;
import com.oracle.bmc.monitoring.responses.RetrieveDimensionStatesResponse;
import com.oracle.bmc.monitoring.responses.SummarizeAlarmSuppressionHistoryResponse;
import com.oracle.bmc.monitoring.responses.SummarizeMetricsDataResponse;
import com.oracle.bmc.monitoring.responses.UpdateAlarmResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={MonitoringAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class MonitoringRxClient {
    MonitoringAsyncClient client;

    MonitoringRxClient(MonitoringAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeAlarmCompartmentResponse> changeAlarmCompartment(ChangeAlarmCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeAlarmCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateAlarmResponse> createAlarm(CreateAlarmRequest request) {
        return Single.create(emitter -> this.client.createAlarm(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateAlarmSuppressionResponse> createAlarmSuppression(CreateAlarmSuppressionRequest request) {
        return Single.create(emitter -> this.client.createAlarmSuppression(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteAlarmResponse> deleteAlarm(DeleteAlarmRequest request) {
        return Single.create(emitter -> this.client.deleteAlarm(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteAlarmSuppressionResponse> deleteAlarmSuppression(DeleteAlarmSuppressionRequest request) {
        return Single.create(emitter -> this.client.deleteAlarmSuppression(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAlarmResponse> getAlarm(GetAlarmRequest request) {
        return Single.create(emitter -> this.client.getAlarm(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAlarmHistoryResponse> getAlarmHistory(GetAlarmHistoryRequest request) {
        return Single.create(emitter -> this.client.getAlarmHistory(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAlarmSuppressionResponse> getAlarmSuppression(GetAlarmSuppressionRequest request) {
        return Single.create(emitter -> this.client.getAlarmSuppression(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAlarmSuppressionsResponse> listAlarmSuppressions(ListAlarmSuppressionsRequest request) {
        return Single.create(emitter -> this.client.listAlarmSuppressions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAlarmsResponse> listAlarms(ListAlarmsRequest request) {
        return Single.create(emitter -> this.client.listAlarms(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAlarmsStatusResponse> listAlarmsStatus(ListAlarmsStatusRequest request) {
        return Single.create(emitter -> this.client.listAlarmsStatus(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListMetricsResponse> listMetrics(ListMetricsRequest request) {
        return Single.create(emitter -> this.client.listMetrics(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<PostMetricDataResponse> postMetricData(PostMetricDataRequest request) {
        return Single.create(emitter -> this.client.postMetricData(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RemoveAlarmSuppressionResponse> removeAlarmSuppression(RemoveAlarmSuppressionRequest request) {
        return Single.create(emitter -> this.client.removeAlarmSuppression(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RetrieveDimensionStatesResponse> retrieveDimensionStates(RetrieveDimensionStatesRequest request) {
        return Single.create(emitter -> this.client.retrieveDimensionStates(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SummarizeAlarmSuppressionHistoryResponse> summarizeAlarmSuppressionHistory(SummarizeAlarmSuppressionHistoryRequest request) {
        return Single.create(emitter -> this.client.summarizeAlarmSuppressionHistory(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SummarizeMetricsDataResponse> summarizeMetricsData(SummarizeMetricsDataRequest request) {
        return Single.create(emitter -> this.client.summarizeMetricsData(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateAlarmResponse> updateAlarm(UpdateAlarmRequest request) {
        return Single.create(emitter -> this.client.updateAlarm(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

