/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.modeldeployment;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.modeldeployment.ModelDeploymentAsyncClient;
import com.oracle.bmc.modeldeployment.requests.PredictRequest;
import com.oracle.bmc.modeldeployment.requests.PredictWithResponseStreamRequest;
import com.oracle.bmc.modeldeployment.responses.PredictResponse;
import com.oracle.bmc.modeldeployment.responses.PredictWithResponseStreamResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ModelDeploymentAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ModelDeploymentRxClient {
    ModelDeploymentAsyncClient client;

    ModelDeploymentRxClient(ModelDeploymentAsyncClient client) {
        this.client = client;
    }

    public Single<PredictResponse> predict(PredictRequest request) {
        return Single.create(emitter -> this.client.predict(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<PredictWithResponseStreamResponse> predictWithResponseStream(PredictWithResponseStreamRequest request) {
        return Single.create(emitter -> this.client.predictWithResponseStream(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

