/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.lustrefilestorage;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.lustrefilestorage.LustreFileStorageAsyncClient;
import com.oracle.bmc.lustrefilestorage.requests.CancelWorkRequestRequest;
import com.oracle.bmc.lustrefilestorage.requests.ChangeLustreFileSystemCompartmentRequest;
import com.oracle.bmc.lustrefilestorage.requests.CreateLustreFileSystemRequest;
import com.oracle.bmc.lustrefilestorage.requests.DeleteLustreFileSystemRequest;
import com.oracle.bmc.lustrefilestorage.requests.GetLustreFileSystemRequest;
import com.oracle.bmc.lustrefilestorage.requests.GetWorkRequestRequest;
import com.oracle.bmc.lustrefilestorage.requests.ListLustreFileSystemsRequest;
import com.oracle.bmc.lustrefilestorage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.lustrefilestorage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.lustrefilestorage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.lustrefilestorage.requests.UpdateLustreFileSystemRequest;
import com.oracle.bmc.lustrefilestorage.responses.CancelWorkRequestResponse;
import com.oracle.bmc.lustrefilestorage.responses.ChangeLustreFileSystemCompartmentResponse;
import com.oracle.bmc.lustrefilestorage.responses.CreateLustreFileSystemResponse;
import com.oracle.bmc.lustrefilestorage.responses.DeleteLustreFileSystemResponse;
import com.oracle.bmc.lustrefilestorage.responses.GetLustreFileSystemResponse;
import com.oracle.bmc.lustrefilestorage.responses.GetWorkRequestResponse;
import com.oracle.bmc.lustrefilestorage.responses.ListLustreFileSystemsResponse;
import com.oracle.bmc.lustrefilestorage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.lustrefilestorage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.lustrefilestorage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.lustrefilestorage.responses.UpdateLustreFileSystemResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={LustreFileStorageAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class LustreFileStorageRxClient {
    LustreFileStorageAsyncClient client;

    LustreFileStorageRxClient(LustreFileStorageAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeLustreFileSystemCompartmentResponse> changeLustreFileSystemCompartment(ChangeLustreFileSystemCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeLustreFileSystemCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateLustreFileSystemResponse> createLustreFileSystem(CreateLustreFileSystemRequest request) {
        return Single.create(emitter -> this.client.createLustreFileSystem(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteLustreFileSystemResponse> deleteLustreFileSystem(DeleteLustreFileSystemRequest request) {
        return Single.create(emitter -> this.client.deleteLustreFileSystem(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetLustreFileSystemResponse> getLustreFileSystem(GetLustreFileSystemRequest request) {
        return Single.create(emitter -> this.client.getLustreFileSystem(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListLustreFileSystemsResponse> listLustreFileSystems(ListLustreFileSystemsRequest request) {
        return Single.create(emitter -> this.client.listLustreFileSystems(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateLustreFileSystemResponse> updateLustreFileSystem(UpdateLustreFileSystemRequest request) {
        return Single.create(emitter -> this.client.updateLustreFileSystem(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

