/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.keymanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.KmsHsmClusterAsyncClient;
import com.oracle.bmc.keymanagement.requests.CancelHsmClusterDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeHsmClusterCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateHsmClusterRequest;
import com.oracle.bmc.keymanagement.requests.DownloadCertificateSigningRequestRequest;
import com.oracle.bmc.keymanagement.requests.GetHsmClusterRequest;
import com.oracle.bmc.keymanagement.requests.GetHsmPartitionRequest;
import com.oracle.bmc.keymanagement.requests.GetPreCoUserCredentialsRequest;
import com.oracle.bmc.keymanagement.requests.ListHsmClustersRequest;
import com.oracle.bmc.keymanagement.requests.ListHsmPartitionsRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleHsmClusterDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateHsmClusterRequest;
import com.oracle.bmc.keymanagement.requests.UploadPartitionCertificatesRequest;
import com.oracle.bmc.keymanagement.responses.CancelHsmClusterDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeHsmClusterCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateHsmClusterResponse;
import com.oracle.bmc.keymanagement.responses.DownloadCertificateSigningRequestResponse;
import com.oracle.bmc.keymanagement.responses.GetHsmClusterResponse;
import com.oracle.bmc.keymanagement.responses.GetHsmPartitionResponse;
import com.oracle.bmc.keymanagement.responses.GetPreCoUserCredentialsResponse;
import com.oracle.bmc.keymanagement.responses.ListHsmClustersResponse;
import com.oracle.bmc.keymanagement.responses.ListHsmPartitionsResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleHsmClusterDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateHsmClusterResponse;
import com.oracle.bmc.keymanagement.responses.UploadPartitionCertificatesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={KmsHsmClusterAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class KmsHsmClusterRxClient {
    KmsHsmClusterAsyncClient client;

    KmsHsmClusterRxClient(KmsHsmClusterAsyncClient client) {
        this.client = client;
    }

    public Single<CancelHsmClusterDeletionResponse> cancelHsmClusterDeletion(CancelHsmClusterDeletionRequest request) {
        return Single.create(emitter -> this.client.cancelHsmClusterDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeHsmClusterCompartmentResponse> changeHsmClusterCompartment(ChangeHsmClusterCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeHsmClusterCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateHsmClusterResponse> createHsmCluster(CreateHsmClusterRequest request) {
        return Single.create(emitter -> this.client.createHsmCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DownloadCertificateSigningRequestResponse> downloadCertificateSigningRequest(DownloadCertificateSigningRequestRequest request) {
        return Single.create(emitter -> this.client.downloadCertificateSigningRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetHsmClusterResponse> getHsmCluster(GetHsmClusterRequest request) {
        return Single.create(emitter -> this.client.getHsmCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetHsmPartitionResponse> getHsmPartition(GetHsmPartitionRequest request) {
        return Single.create(emitter -> this.client.getHsmPartition(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetPreCoUserCredentialsResponse> getPreCoUserCredentials(GetPreCoUserCredentialsRequest request) {
        return Single.create(emitter -> this.client.getPreCoUserCredentials(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListHsmClustersResponse> listHsmClusters(ListHsmClustersRequest request) {
        return Single.create(emitter -> this.client.listHsmClusters(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListHsmPartitionsResponse> listHsmPartitions(ListHsmPartitionsRequest request) {
        return Single.create(emitter -> this.client.listHsmPartitions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ScheduleHsmClusterDeletionResponse> scheduleHsmClusterDeletion(ScheduleHsmClusterDeletionRequest request) {
        return Single.create(emitter -> this.client.scheduleHsmClusterDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateHsmClusterResponse> updateHsmCluster(UpdateHsmClusterRequest request) {
        return Single.create(emitter -> this.client.updateHsmCluster(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UploadPartitionCertificatesResponse> uploadPartitionCertificates(UploadPartitionCertificatesRequest request) {
        return Single.create(emitter -> this.client.uploadPartitionCertificates(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

