/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.identitydataplane;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.identitydataplane.DataplaneAsyncClient;
import com.oracle.bmc.identitydataplane.requests.GenerateScopedAccessTokenRequest;
import com.oracle.bmc.identitydataplane.requests.GenerateUserSecurityTokenRequest;
import com.oracle.bmc.identitydataplane.responses.GenerateScopedAccessTokenResponse;
import com.oracle.bmc.identitydataplane.responses.GenerateUserSecurityTokenResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={DataplaneAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DataplaneRxClient {
    DataplaneAsyncClient client;

    DataplaneRxClient(DataplaneAsyncClient client) {
        this.client = client;
    }

    public Single<GenerateScopedAccessTokenResponse> generateScopedAccessToken(GenerateScopedAccessTokenRequest request) {
        return Single.create(emitter -> this.client.generateScopedAccessToken(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GenerateUserSecurityTokenResponse> generateUserSecurityToken(GenerateUserSecurityTokenRequest request) {
        return Single.create(emitter -> this.client.generateUserSecurityToken(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

