/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.governancerulescontrolplane;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.governancerulescontrolplane.WorkRequestAsyncClient;
import com.oracle.bmc.governancerulescontrolplane.requests.CancelWorkRequestRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.GetWorkRequestRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.governancerulescontrolplane.requests.ListWorkRequestsRequest;
import com.oracle.bmc.governancerulescontrolplane.responses.CancelWorkRequestResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.GetWorkRequestResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.governancerulescontrolplane.responses.ListWorkRequestsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={WorkRequestAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class WorkRequestRxClient {
    WorkRequestAsyncClient client;

    WorkRequestRxClient(WorkRequestAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

