/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.generativeaiinference;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.generativeaiinference.GenerativeAiInferenceAsyncClient;
import com.oracle.bmc.generativeaiinference.requests.ApplyGuardrailsRequest;
import com.oracle.bmc.generativeaiinference.requests.ChatRequest;
import com.oracle.bmc.generativeaiinference.requests.EmbedTextRequest;
import com.oracle.bmc.generativeaiinference.requests.GenerateTextRequest;
import com.oracle.bmc.generativeaiinference.requests.RerankTextRequest;
import com.oracle.bmc.generativeaiinference.requests.SummarizeTextRequest;
import com.oracle.bmc.generativeaiinference.responses.ApplyGuardrailsResponse;
import com.oracle.bmc.generativeaiinference.responses.ChatResponse;
import com.oracle.bmc.generativeaiinference.responses.EmbedTextResponse;
import com.oracle.bmc.generativeaiinference.responses.GenerateTextResponse;
import com.oracle.bmc.generativeaiinference.responses.RerankTextResponse;
import com.oracle.bmc.generativeaiinference.responses.SummarizeTextResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={GenerativeAiInferenceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class GenerativeAiInferenceRxClient {
    GenerativeAiInferenceAsyncClient client;

    GenerativeAiInferenceRxClient(GenerativeAiInferenceAsyncClient client) {
        this.client = client;
    }

    public Single<ApplyGuardrailsResponse> applyGuardrails(ApplyGuardrailsRequest request) {
        return Single.create(emitter -> this.client.applyGuardrails(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChatResponse> chat(ChatRequest request) {
        return Single.create(emitter -> this.client.chat(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<EmbedTextResponse> embedText(EmbedTextRequest request) {
        return Single.create(emitter -> this.client.embedText(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GenerateTextResponse> generateText(GenerateTextRequest request) {
        return Single.create(emitter -> this.client.generateText(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RerankTextResponse> rerankText(RerankTextRequest request) {
        return Single.create(emitter -> this.client.rerankText(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SummarizeTextResponse> summarizeText(SummarizeTextRequest request) {
        return Single.create(emitter -> this.client.summarizeText(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

