/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.generativeaiagentruntime;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.generativeaiagentruntime.GenerativeAiAgentRuntimeAsyncClient;
import com.oracle.bmc.generativeaiagentruntime.requests.ChatRequest;
import com.oracle.bmc.generativeaiagentruntime.requests.CreateSessionRequest;
import com.oracle.bmc.generativeaiagentruntime.requests.DeleteSessionRequest;
import com.oracle.bmc.generativeaiagentruntime.requests.GetSessionRequest;
import com.oracle.bmc.generativeaiagentruntime.requests.RetrieveMetadataRequest;
import com.oracle.bmc.generativeaiagentruntime.requests.UpdateSessionRequest;
import com.oracle.bmc.generativeaiagentruntime.responses.ChatResponse;
import com.oracle.bmc.generativeaiagentruntime.responses.CreateSessionResponse;
import com.oracle.bmc.generativeaiagentruntime.responses.DeleteSessionResponse;
import com.oracle.bmc.generativeaiagentruntime.responses.GetSessionResponse;
import com.oracle.bmc.generativeaiagentruntime.responses.RetrieveMetadataResponse;
import com.oracle.bmc.generativeaiagentruntime.responses.UpdateSessionResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={GenerativeAiAgentRuntimeAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class GenerativeAiAgentRuntimeRxClient {
    GenerativeAiAgentRuntimeAsyncClient client;

    GenerativeAiAgentRuntimeRxClient(GenerativeAiAgentRuntimeAsyncClient client) {
        this.client = client;
    }

    public Single<ChatResponse> chat(ChatRequest request) {
        return Single.create(emitter -> this.client.chat(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateSessionResponse> createSession(CreateSessionRequest request) {
        return Single.create(emitter -> this.client.createSession(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteSessionResponse> deleteSession(DeleteSessionRequest request) {
        return Single.create(emitter -> this.client.deleteSession(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSessionResponse> getSession(GetSessionRequest request) {
        return Single.create(emitter -> this.client.getSession(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RetrieveMetadataResponse> retrieveMetadata(RetrieveMetadataRequest request) {
        return Single.create(emitter -> this.client.retrieveMetadata(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateSessionResponse> updateSession(UpdateSessionRequest request) {
        return Single.create(emitter -> this.client.updateSession(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

