/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.fleetappsmanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.fleetappsmanagement.FleetAppsManagementWorkRequestAsyncClient;
import com.oracle.bmc.fleetappsmanagement.requests.GetWorkRequestRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.fleetappsmanagement.requests.ListWorkRequestsRequest;
import com.oracle.bmc.fleetappsmanagement.responses.GetWorkRequestResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.fleetappsmanagement.responses.ListWorkRequestsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={FleetAppsManagementWorkRequestAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class FleetAppsManagementWorkRequestRxClient {
    FleetAppsManagementWorkRequestAsyncClient client;

    FleetAppsManagementWorkRequestRxClient(FleetAppsManagementWorkRequestAsyncClient client) {
        this.client = client;
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

