/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.dbmulticloud;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.dbmulticloud.WorkRequestAsyncClient;
import com.oracle.bmc.dbmulticloud.requests.CancelWorkRequestRequest;
import com.oracle.bmc.dbmulticloud.requests.GetWorkRequestRequest;
import com.oracle.bmc.dbmulticloud.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dbmulticloud.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dbmulticloud.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dbmulticloud.responses.CancelWorkRequestResponse;
import com.oracle.bmc.dbmulticloud.responses.GetWorkRequestResponse;
import com.oracle.bmc.dbmulticloud.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dbmulticloud.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dbmulticloud.responses.ListWorkRequestsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={WorkRequestAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class WorkRequestRxClient {
    WorkRequestAsyncClient client;

    WorkRequestRxClient(WorkRequestAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

