/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.dbmulticloud;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.dbmulticloud.OracleDbAzureKeyAsyncClient;
import com.oracle.bmc.dbmulticloud.requests.GetOracleDbAzureKeyRequest;
import com.oracle.bmc.dbmulticloud.requests.ListOracleDbAzureKeysRequest;
import com.oracle.bmc.dbmulticloud.responses.GetOracleDbAzureKeyResponse;
import com.oracle.bmc.dbmulticloud.responses.ListOracleDbAzureKeysResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={OracleDbAzureKeyAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OracleDbAzureKeyRxClient {
    OracleDbAzureKeyAsyncClient client;

    OracleDbAzureKeyRxClient(OracleDbAzureKeyAsyncClient client) {
        this.client = client;
    }

    public Single<GetOracleDbAzureKeyResponse> getOracleDbAzureKey(GetOracleDbAzureKeyRequest request) {
        return Single.create(emitter -> this.client.getOracleDbAzureKey(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListOracleDbAzureKeysResponse> listOracleDbAzureKeys(ListOracleDbAzureKeysRequest request) {
        return Single.create(emitter -> this.client.listOracleDbAzureKeys(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

