/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.datalabelingservicedataplane;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.datalabelingservicedataplane.DataLabelingAsyncClient;
import com.oracle.bmc.datalabelingservicedataplane.requests.CreateAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.CreateRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.DeleteAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.DeleteRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetDatasetRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetRecordContentRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetRecordPreviewContentRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.ListAnnotationsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.ListRecordsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.SummarizeAnnotationAnalyticsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.SummarizeRecordAnalyticsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.UpdateAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.UpdateRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.responses.CreateAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.CreateRecordResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.DeleteAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.DeleteRecordResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetDatasetResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetRecordContentResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetRecordPreviewContentResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetRecordResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.ListAnnotationsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.ListRecordsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.SummarizeAnnotationAnalyticsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.SummarizeRecordAnalyticsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.UpdateAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.UpdateRecordResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={DataLabelingAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DataLabelingRxClient {
    DataLabelingAsyncClient client;

    DataLabelingRxClient(DataLabelingAsyncClient client) {
        this.client = client;
    }

    public Single<CreateAnnotationResponse> createAnnotation(CreateAnnotationRequest request) {
        return Single.create(emitter -> this.client.createAnnotation(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateRecordResponse> createRecord(CreateRecordRequest request) {
        return Single.create(emitter -> this.client.createRecord(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteAnnotationResponse> deleteAnnotation(DeleteAnnotationRequest request) {
        return Single.create(emitter -> this.client.deleteAnnotation(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteRecordResponse> deleteRecord(DeleteRecordRequest request) {
        return Single.create(emitter -> this.client.deleteRecord(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAnnotationResponse> getAnnotation(GetAnnotationRequest request) {
        return Single.create(emitter -> this.client.getAnnotation(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetDatasetResponse> getDataset(GetDatasetRequest request) {
        return Single.create(emitter -> this.client.getDataset(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetRecordResponse> getRecord(GetRecordRequest request) {
        return Single.create(emitter -> this.client.getRecord(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetRecordContentResponse> getRecordContent(GetRecordContentRequest request) {
        return Single.create(emitter -> this.client.getRecordContent(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetRecordPreviewContentResponse> getRecordPreviewContent(GetRecordPreviewContentRequest request) {
        return Single.create(emitter -> this.client.getRecordPreviewContent(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAnnotationsResponse> listAnnotations(ListAnnotationsRequest request) {
        return Single.create(emitter -> this.client.listAnnotations(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListRecordsResponse> listRecords(ListRecordsRequest request) {
        return Single.create(emitter -> this.client.listRecords(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SummarizeAnnotationAnalyticsResponse> summarizeAnnotationAnalytics(SummarizeAnnotationAnalyticsRequest request) {
        return Single.create(emitter -> this.client.summarizeAnnotationAnalytics(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SummarizeRecordAnalyticsResponse> summarizeRecordAnalytics(SummarizeRecordAnalyticsRequest request) {
        return Single.create(emitter -> this.client.summarizeRecordAnalytics(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateAnnotationResponse> updateAnnotation(UpdateAnnotationRequest request) {
        return Single.create(emitter -> this.client.updateAnnotation(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateRecordResponse> updateRecord(UpdateRecordRequest request) {
        return Single.create(emitter -> this.client.updateRecord(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

