/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.databasemanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.databasemanagement.DiagnosabilityAsyncClient;
import com.oracle.bmc.databasemanagement.requests.ListAlertLogsRequest;
import com.oracle.bmc.databasemanagement.requests.ListAttentionLogsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAlertLogCountsRequest;
import com.oracle.bmc.databasemanagement.requests.SummarizeAttentionLogCountsRequest;
import com.oracle.bmc.databasemanagement.responses.ListAlertLogsResponse;
import com.oracle.bmc.databasemanagement.responses.ListAttentionLogsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAlertLogCountsResponse;
import com.oracle.bmc.databasemanagement.responses.SummarizeAttentionLogCountsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={DiagnosabilityAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DiagnosabilityRxClient {
    DiagnosabilityAsyncClient client;

    DiagnosabilityRxClient(DiagnosabilityAsyncClient client) {
        this.client = client;
    }

    public Single<ListAlertLogsResponse> listAlertLogs(ListAlertLogsRequest request) {
        return Single.create(emitter -> this.client.listAlertLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAttentionLogsResponse> listAttentionLogs(ListAttentionLogsRequest request) {
        return Single.create(emitter -> this.client.listAttentionLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SummarizeAlertLogCountsResponse> summarizeAlertLogCounts(SummarizeAlertLogCountsRequest request) {
        return Single.create(emitter -> this.client.summarizeAlertLogCounts(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SummarizeAttentionLogCountsResponse> summarizeAttentionLogCounts(SummarizeAttentionLogCountsRequest request) {
        return Single.create(emitter -> this.client.summarizeAttentionLogCounts(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

