/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.audit;

import com.oracle.bmc.audit.AuditAsyncClient;
import com.oracle.bmc.audit.requests.GetConfigurationRequest;
import com.oracle.bmc.audit.requests.ListEventsRequest;
import com.oracle.bmc.audit.requests.UpdateConfigurationRequest;
import com.oracle.bmc.audit.responses.GetConfigurationResponse;
import com.oracle.bmc.audit.responses.ListEventsResponse;
import com.oracle.bmc.audit.responses.UpdateConfigurationResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={AuditAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AuditRxClient {
    AuditAsyncClient client;

    AuditRxClient(AuditAsyncClient client) {
        this.client = client;
    }

    public Single<GetConfigurationResponse> getConfiguration(GetConfigurationRequest request) {
        return Single.create(emitter -> this.client.getConfiguration(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListEventsResponse> listEvents(ListEventsRequest request) {
        return Single.create(emitter -> this.client.listEvents(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateConfigurationResponse> updateConfiguration(UpdateConfigurationRequest request) {
        return Single.create(emitter -> this.client.updateConfiguration(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

