/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.apmtraces;

import com.oracle.bmc.apmtraces.ScheduledQueryAsyncClient;
import com.oracle.bmc.apmtraces.requests.CreateScheduledQueryRequest;
import com.oracle.bmc.apmtraces.requests.DeleteScheduledQueryRequest;
import com.oracle.bmc.apmtraces.requests.GetScheduledQueryRequest;
import com.oracle.bmc.apmtraces.requests.ListScheduledQueriesRequest;
import com.oracle.bmc.apmtraces.requests.UpdateScheduledQueryRequest;
import com.oracle.bmc.apmtraces.responses.CreateScheduledQueryResponse;
import com.oracle.bmc.apmtraces.responses.DeleteScheduledQueryResponse;
import com.oracle.bmc.apmtraces.responses.GetScheduledQueryResponse;
import com.oracle.bmc.apmtraces.responses.ListScheduledQueriesResponse;
import com.oracle.bmc.apmtraces.responses.UpdateScheduledQueryResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ScheduledQueryAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ScheduledQueryRxClient {
    ScheduledQueryAsyncClient client;

    ScheduledQueryRxClient(ScheduledQueryAsyncClient client) {
        this.client = client;
    }

    public Single<CreateScheduledQueryResponse> createScheduledQuery(CreateScheduledQueryRequest request) {
        return Single.create(emitter -> this.client.createScheduledQuery(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteScheduledQueryResponse> deleteScheduledQuery(DeleteScheduledQueryRequest request) {
        return Single.create(emitter -> this.client.deleteScheduledQuery(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetScheduledQueryResponse> getScheduledQuery(GetScheduledQueryRequest request) {
        return Single.create(emitter -> this.client.getScheduledQuery(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListScheduledQueriesResponse> listScheduledQueries(ListScheduledQueriesRequest request) {
        return Single.create(emitter -> this.client.listScheduledQueries(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateScheduledQueryResponse> updateScheduledQuery(UpdateScheduledQueryRequest request) {
        return Single.create(emitter -> this.client.updateScheduledQuery(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

