/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.apiaccesscontrol;

import com.oracle.bmc.apiaccesscontrol.ApiMetadataAsyncClient;
import com.oracle.bmc.apiaccesscontrol.requests.GetApiMetadataRequest;
import com.oracle.bmc.apiaccesscontrol.requests.ListApiMetadataByEntityTypesRequest;
import com.oracle.bmc.apiaccesscontrol.requests.ListApiMetadataRequest;
import com.oracle.bmc.apiaccesscontrol.responses.GetApiMetadataResponse;
import com.oracle.bmc.apiaccesscontrol.responses.ListApiMetadataByEntityTypesResponse;
import com.oracle.bmc.apiaccesscontrol.responses.ListApiMetadataResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ApiMetadataAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ApiMetadataRxClient {
    ApiMetadataAsyncClient client;

    ApiMetadataRxClient(ApiMetadataAsyncClient client) {
        this.client = client;
    }

    public Single<GetApiMetadataResponse> getApiMetadata(GetApiMetadataRequest request) {
        return Single.create(emitter -> this.client.getApiMetadata(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListApiMetadataResponse> listApiMetadata(ListApiMetadataRequest request) {
        return Single.create(emitter -> this.client.listApiMetadata(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListApiMetadataByEntityTypesResponse> listApiMetadataByEntityTypes(ListApiMetadataByEntityTypesRequest request) {
        return Single.create(emitter -> this.client.listApiMetadataByEntityTypes(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

