/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.usage;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.usage.ResourcesAsyncClient;
import com.oracle.bmc.usage.requests.ListResourceQuotaRequest;
import com.oracle.bmc.usage.requests.ListResourcesRequest;
import com.oracle.bmc.usage.responses.ListResourceQuotaResponse;
import com.oracle.bmc.usage.responses.ListResourcesResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ResourcesAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ResourcesRxClient {
    ResourcesAsyncClient client;

    ResourcesRxClient(ResourcesAsyncClient client) {
        this.client = client;
    }

    public Single<ListResourceQuotaResponse> listResourceQuota(ListResourceQuotaRequest request) {
        return Single.create(emitter -> this.client.listResourceQuota(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListResourcesResponse> listResources(ListResourcesRequest request) {
        return Single.create(emitter -> this.client.listResources(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

