/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.tenantmanagercontrolplane;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.OrdersAsyncClient;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ActivateOrderRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetOrderRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ActivateOrderResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetOrderResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={OrdersAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OrdersRxClient {
    OrdersAsyncClient client;

    OrdersRxClient(OrdersAsyncClient client) {
        this.client = client;
    }

    public Single<ActivateOrderResponse> activateOrder(ActivateOrderRequest request) {
        return Single.create(emitter -> this.client.activateOrder(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetOrderResponse> getOrder(GetOrderRequest request) {
        return Single.create(emitter -> this.client.getOrder(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

