/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.tenantmanagercontrolplane;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.LinkAsyncClient;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteLinkRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetLinkRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListLinksRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteLinkResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetLinkResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListLinksResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={LinkAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class LinkRxClient {
    LinkAsyncClient client;

    LinkRxClient(LinkAsyncClient client) {
        this.client = client;
    }

    public Single<DeleteLinkResponse> deleteLink(DeleteLinkRequest request) {
        return Single.create(emitter -> this.client.deleteLink(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetLinkResponse> getLink(GetLinkRequest request) {
        return Single.create(emitter -> this.client.getLink(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListLinksResponse> listLinks(ListLinksRequest request) {
        return Single.create(emitter -> this.client.listLinks(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

