/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.ospgateway;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.ospgateway.SubscriptionServiceAsyncClient;
import com.oracle.bmc.ospgateway.requests.AuthorizeSubscriptionPaymentRequest;
import com.oracle.bmc.ospgateway.requests.GetSubscriptionRequest;
import com.oracle.bmc.ospgateway.requests.ListSubscriptionsRequest;
import com.oracle.bmc.ospgateway.requests.PaySubscriptionRequest;
import com.oracle.bmc.ospgateway.requests.UpdateSubscriptionRequest;
import com.oracle.bmc.ospgateway.responses.AuthorizeSubscriptionPaymentResponse;
import com.oracle.bmc.ospgateway.responses.GetSubscriptionResponse;
import com.oracle.bmc.ospgateway.responses.ListSubscriptionsResponse;
import com.oracle.bmc.ospgateway.responses.PaySubscriptionResponse;
import com.oracle.bmc.ospgateway.responses.UpdateSubscriptionResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={SubscriptionServiceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class SubscriptionServiceRxClient {
    SubscriptionServiceAsyncClient client;

    SubscriptionServiceRxClient(SubscriptionServiceAsyncClient client) {
        this.client = client;
    }

    public Single<AuthorizeSubscriptionPaymentResponse> authorizeSubscriptionPayment(AuthorizeSubscriptionPaymentRequest request) {
        return Single.create(emitter -> this.client.authorizeSubscriptionPayment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetSubscriptionResponse> getSubscription(GetSubscriptionRequest request) {
        return Single.create(emitter -> this.client.getSubscription(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest request) {
        return Single.create(emitter -> this.client.listSubscriptions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<PaySubscriptionResponse> paySubscription(PaySubscriptionRequest request) {
        return Single.create(emitter -> this.client.paySubscription(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateSubscriptionResponse> updateSubscription(UpdateSubscriptionRequest request) {
        return Single.create(emitter -> this.client.updateSubscription(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

