/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.mngdmac;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.mngdmac.MacDeviceAsyncClient;
import com.oracle.bmc.mngdmac.requests.GetMacDeviceRequest;
import com.oracle.bmc.mngdmac.requests.ListMacDevicesRequest;
import com.oracle.bmc.mngdmac.requests.TerminateMacDeviceRequest;
import com.oracle.bmc.mngdmac.responses.GetMacDeviceResponse;
import com.oracle.bmc.mngdmac.responses.ListMacDevicesResponse;
import com.oracle.bmc.mngdmac.responses.TerminateMacDeviceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={MacDeviceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class MacDeviceRxClient {
    MacDeviceAsyncClient client;

    MacDeviceRxClient(MacDeviceAsyncClient client) {
        this.client = client;
    }

    public Single<GetMacDeviceResponse> getMacDevice(GetMacDeviceRequest request) {
        return Single.create(emitter -> this.client.getMacDevice(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListMacDevicesResponse> listMacDevices(ListMacDevicesRequest request) {
        return Single.create(emitter -> this.client.listMacDevices(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<TerminateMacDeviceResponse> terminateMacDevice(TerminateMacDeviceRequest request) {
        return Single.create(emitter -> this.client.terminateMacDevice(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

