/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.keymanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.KmsManagementAsyncClient;
import com.oracle.bmc.keymanagement.requests.BackupKeyRequest;
import com.oracle.bmc.keymanagement.requests.CancelKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.CancelKeyVersionDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeKeyCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.DisableKeyRequest;
import com.oracle.bmc.keymanagement.requests.EnableKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.GetReplicationStatusRequest;
import com.oracle.bmc.keymanagement.requests.GetWrappingKeyRequest;
import com.oracle.bmc.keymanagement.requests.ImportKeyRequest;
import com.oracle.bmc.keymanagement.requests.ImportKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.ListKeyVersionsRequest;
import com.oracle.bmc.keymanagement.requests.ListKeysRequest;
import com.oracle.bmc.keymanagement.requests.RestoreKeyFromFileRequest;
import com.oracle.bmc.keymanagement.requests.RestoreKeyFromObjectStoreRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleKeyVersionDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateKeyRequest;
import com.oracle.bmc.keymanagement.responses.BackupKeyResponse;
import com.oracle.bmc.keymanagement.responses.CancelKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.CancelKeyVersionDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeKeyCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.DisableKeyResponse;
import com.oracle.bmc.keymanagement.responses.EnableKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.GetReplicationStatusResponse;
import com.oracle.bmc.keymanagement.responses.GetWrappingKeyResponse;
import com.oracle.bmc.keymanagement.responses.ImportKeyResponse;
import com.oracle.bmc.keymanagement.responses.ImportKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.ListKeyVersionsResponse;
import com.oracle.bmc.keymanagement.responses.ListKeysResponse;
import com.oracle.bmc.keymanagement.responses.RestoreKeyFromFileResponse;
import com.oracle.bmc.keymanagement.responses.RestoreKeyFromObjectStoreResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleKeyVersionDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateKeyResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={KmsManagementAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class KmsManagementRxClient {
    KmsManagementAsyncClient client;

    KmsManagementRxClient(KmsManagementAsyncClient client) {
        this.client = client;
    }

    public Single<BackupKeyResponse> backupKey(BackupKeyRequest request) {
        return Single.create(emitter -> this.client.backupKey(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CancelKeyDeletionResponse> cancelKeyDeletion(CancelKeyDeletionRequest request) {
        return Single.create(emitter -> this.client.cancelKeyDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CancelKeyVersionDeletionResponse> cancelKeyVersionDeletion(CancelKeyVersionDeletionRequest request) {
        return Single.create(emitter -> this.client.cancelKeyVersionDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeKeyCompartmentResponse> changeKeyCompartment(ChangeKeyCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeKeyCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateKeyResponse> createKey(CreateKeyRequest request) {
        return Single.create(emitter -> this.client.createKey(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateKeyVersionResponse> createKeyVersion(CreateKeyVersionRequest request) {
        return Single.create(emitter -> this.client.createKeyVersion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DisableKeyResponse> disableKey(DisableKeyRequest request) {
        return Single.create(emitter -> this.client.disableKey(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<EnableKeyResponse> enableKey(EnableKeyRequest request) {
        return Single.create(emitter -> this.client.enableKey(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetKeyResponse> getKey(GetKeyRequest request) {
        return Single.create(emitter -> this.client.getKey(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetKeyVersionResponse> getKeyVersion(GetKeyVersionRequest request) {
        return Single.create(emitter -> this.client.getKeyVersion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetReplicationStatusResponse> getReplicationStatus(GetReplicationStatusRequest request) {
        return Single.create(emitter -> this.client.getReplicationStatus(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWrappingKeyResponse> getWrappingKey(GetWrappingKeyRequest request) {
        return Single.create(emitter -> this.client.getWrappingKey(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ImportKeyResponse> importKey(ImportKeyRequest request) {
        return Single.create(emitter -> this.client.importKey(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ImportKeyVersionResponse> importKeyVersion(ImportKeyVersionRequest request) {
        return Single.create(emitter -> this.client.importKeyVersion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListKeyVersionsResponse> listKeyVersions(ListKeyVersionsRequest request) {
        return Single.create(emitter -> this.client.listKeyVersions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListKeysResponse> listKeys(ListKeysRequest request) {
        return Single.create(emitter -> this.client.listKeys(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RestoreKeyFromFileResponse> restoreKeyFromFile(RestoreKeyFromFileRequest request) {
        return Single.create(emitter -> this.client.restoreKeyFromFile(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RestoreKeyFromObjectStoreResponse> restoreKeyFromObjectStore(RestoreKeyFromObjectStoreRequest request) {
        return Single.create(emitter -> this.client.restoreKeyFromObjectStore(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ScheduleKeyDeletionResponse> scheduleKeyDeletion(ScheduleKeyDeletionRequest request) {
        return Single.create(emitter -> this.client.scheduleKeyDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ScheduleKeyVersionDeletionResponse> scheduleKeyVersionDeletion(ScheduleKeyVersionDeletionRequest request) {
        return Single.create(emitter -> this.client.scheduleKeyVersionDeletion(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateKeyResponse> updateKey(UpdateKeyRequest request) {
        return Single.create(emitter -> this.client.updateKey(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

