/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.emwarehouse;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.emwarehouse.EmWarehouseAsyncClient;
import com.oracle.bmc.emwarehouse.requests.CancelWorkRequestRequest;
import com.oracle.bmc.emwarehouse.requests.ChangeEmWarehouseCompartmentRequest;
import com.oracle.bmc.emwarehouse.requests.CreateEmWarehouseRequest;
import com.oracle.bmc.emwarehouse.requests.DeleteEmWarehouseRequest;
import com.oracle.bmc.emwarehouse.requests.GetEmWarehouseRequest;
import com.oracle.bmc.emwarehouse.requests.GetEmWarehouseResourceUsageRequest;
import com.oracle.bmc.emwarehouse.requests.GetWorkRequestRequest;
import com.oracle.bmc.emwarehouse.requests.ListEmWarehousesRequest;
import com.oracle.bmc.emwarehouse.requests.ListEtlRunsRequest;
import com.oracle.bmc.emwarehouse.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.emwarehouse.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.emwarehouse.requests.ListWorkRequestsRequest;
import com.oracle.bmc.emwarehouse.requests.UpdateEmWarehouseRequest;
import com.oracle.bmc.emwarehouse.responses.CancelWorkRequestResponse;
import com.oracle.bmc.emwarehouse.responses.ChangeEmWarehouseCompartmentResponse;
import com.oracle.bmc.emwarehouse.responses.CreateEmWarehouseResponse;
import com.oracle.bmc.emwarehouse.responses.DeleteEmWarehouseResponse;
import com.oracle.bmc.emwarehouse.responses.GetEmWarehouseResourceUsageResponse;
import com.oracle.bmc.emwarehouse.responses.GetEmWarehouseResponse;
import com.oracle.bmc.emwarehouse.responses.GetWorkRequestResponse;
import com.oracle.bmc.emwarehouse.responses.ListEmWarehousesResponse;
import com.oracle.bmc.emwarehouse.responses.ListEtlRunsResponse;
import com.oracle.bmc.emwarehouse.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.emwarehouse.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.emwarehouse.responses.ListWorkRequestsResponse;
import com.oracle.bmc.emwarehouse.responses.UpdateEmWarehouseResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={EmWarehouseAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class EmWarehouseRxClient {
    EmWarehouseAsyncClient client;

    EmWarehouseRxClient(EmWarehouseAsyncClient client) {
        this.client = client;
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeEmWarehouseCompartmentResponse> changeEmWarehouseCompartment(ChangeEmWarehouseCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeEmWarehouseCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateEmWarehouseResponse> createEmWarehouse(CreateEmWarehouseRequest request) {
        return Single.create(emitter -> this.client.createEmWarehouse(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteEmWarehouseResponse> deleteEmWarehouse(DeleteEmWarehouseRequest request) {
        return Single.create(emitter -> this.client.deleteEmWarehouse(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetEmWarehouseResponse> getEmWarehouse(GetEmWarehouseRequest request) {
        return Single.create(emitter -> this.client.getEmWarehouse(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetEmWarehouseResourceUsageResponse> getEmWarehouseResourceUsage(GetEmWarehouseResourceUsageRequest request) {
        return Single.create(emitter -> this.client.getEmWarehouseResourceUsage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListEmWarehousesResponse> listEmWarehouses(ListEmWarehousesRequest request) {
        return Single.create(emitter -> this.client.listEmWarehouses(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListEtlRunsResponse> listEtlRuns(ListEtlRunsRequest request) {
        return Single.create(emitter -> this.client.listEtlRuns(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateEmWarehouseResponse> updateEmWarehouse(UpdateEmWarehouseRequest request) {
        return Single.create(emitter -> this.client.updateEmWarehouse(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

