/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.distributeddatabase;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.distributeddatabase.DistributedDbWorkRequestServiceAsyncClient;
import com.oracle.bmc.distributeddatabase.requests.GetWorkRequestRequest;
import com.oracle.bmc.distributeddatabase.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.distributeddatabase.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.distributeddatabase.requests.ListWorkRequestsRequest;
import com.oracle.bmc.distributeddatabase.responses.GetWorkRequestResponse;
import com.oracle.bmc.distributeddatabase.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.distributeddatabase.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.distributeddatabase.responses.ListWorkRequestsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={DistributedDbWorkRequestServiceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DistributedDbWorkRequestServiceRxClient {
    DistributedDbWorkRequestServiceAsyncClient client;

    DistributedDbWorkRequestServiceRxClient(DistributedDbWorkRequestServiceAsyncClient client) {
        this.client = client;
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

