/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.apiaccesscontrol;

import com.oracle.bmc.apiaccesscontrol.PrivilegedApiRequestsAsyncClient;
import com.oracle.bmc.apiaccesscontrol.requests.ApprovePrivilegedApiRequestRequest;
import com.oracle.bmc.apiaccesscontrol.requests.ClosePrivilegedApiRequestRequest;
import com.oracle.bmc.apiaccesscontrol.requests.CreatePrivilegedApiRequestRequest;
import com.oracle.bmc.apiaccesscontrol.requests.GetPrivilegedApiRequestRequest;
import com.oracle.bmc.apiaccesscontrol.requests.ListPrivilegedApiRequestsRequest;
import com.oracle.bmc.apiaccesscontrol.requests.RejectPrivilegedApiRequestRequest;
import com.oracle.bmc.apiaccesscontrol.requests.RevokePrivilegedApiRequestRequest;
import com.oracle.bmc.apiaccesscontrol.responses.ApprovePrivilegedApiRequestResponse;
import com.oracle.bmc.apiaccesscontrol.responses.ClosePrivilegedApiRequestResponse;
import com.oracle.bmc.apiaccesscontrol.responses.CreatePrivilegedApiRequestResponse;
import com.oracle.bmc.apiaccesscontrol.responses.GetPrivilegedApiRequestResponse;
import com.oracle.bmc.apiaccesscontrol.responses.ListPrivilegedApiRequestsResponse;
import com.oracle.bmc.apiaccesscontrol.responses.RejectPrivilegedApiRequestResponse;
import com.oracle.bmc.apiaccesscontrol.responses.RevokePrivilegedApiRequestResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={PrivilegedApiRequestsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class PrivilegedApiRequestsRxClient {
    PrivilegedApiRequestsAsyncClient client;

    PrivilegedApiRequestsRxClient(PrivilegedApiRequestsAsyncClient client) {
        this.client = client;
    }

    public Single<ApprovePrivilegedApiRequestResponse> approvePrivilegedApiRequest(ApprovePrivilegedApiRequestRequest request) {
        return Single.create(emitter -> this.client.approvePrivilegedApiRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ClosePrivilegedApiRequestResponse> closePrivilegedApiRequest(ClosePrivilegedApiRequestRequest request) {
        return Single.create(emitter -> this.client.closePrivilegedApiRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreatePrivilegedApiRequestResponse> createPrivilegedApiRequest(CreatePrivilegedApiRequestRequest request) {
        return Single.create(emitter -> this.client.createPrivilegedApiRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetPrivilegedApiRequestResponse> getPrivilegedApiRequest(GetPrivilegedApiRequestRequest request) {
        return Single.create(emitter -> this.client.getPrivilegedApiRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListPrivilegedApiRequestsResponse> listPrivilegedApiRequests(ListPrivilegedApiRequestsRequest request) {
        return Single.create(emitter -> this.client.listPrivilegedApiRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RejectPrivilegedApiRequestResponse> rejectPrivilegedApiRequest(RejectPrivilegedApiRequestRequest request) {
        return Single.create(emitter -> this.client.rejectPrivilegedApiRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<RevokePrivilegedApiRequestResponse> revokePrivilegedApiRequest(RevokePrivilegedApiRequestRequest request) {
        return Single.create(emitter -> this.client.revokePrivilegedApiRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

