/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.threatintelligence;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.threatintelligence.ThreatintelAsyncClient;
import com.oracle.bmc.threatintelligence.requests.GetIndicatorRequest;
import com.oracle.bmc.threatintelligence.requests.ListIndicatorCountsRequest;
import com.oracle.bmc.threatintelligence.requests.ListIndicatorsRequest;
import com.oracle.bmc.threatintelligence.requests.ListThreatTypesRequest;
import com.oracle.bmc.threatintelligence.requests.SummarizeIndicatorsRequest;
import com.oracle.bmc.threatintelligence.responses.GetIndicatorResponse;
import com.oracle.bmc.threatintelligence.responses.ListIndicatorCountsResponse;
import com.oracle.bmc.threatintelligence.responses.ListIndicatorsResponse;
import com.oracle.bmc.threatintelligence.responses.ListThreatTypesResponse;
import com.oracle.bmc.threatintelligence.responses.SummarizeIndicatorsResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ThreatintelAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ThreatintelRxClient {
    ThreatintelAsyncClient client;

    ThreatintelRxClient(ThreatintelAsyncClient client) {
        this.client = client;
    }

    public Single<GetIndicatorResponse> getIndicator(GetIndicatorRequest request) {
        return Single.create(emitter -> this.client.getIndicator(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListIndicatorCountsResponse> listIndicatorCounts(ListIndicatorCountsRequest request) {
        return Single.create(emitter -> this.client.listIndicatorCounts(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListIndicatorsResponse> listIndicators(ListIndicatorsRequest request) {
        return Single.create(emitter -> this.client.listIndicators(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListThreatTypesResponse> listThreatTypes(ListThreatTypesRequest request) {
        return Single.create(emitter -> this.client.listThreatTypes(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SummarizeIndicatorsResponse> summarizeIndicators(SummarizeIndicatorsRequest request) {
        return Single.create(emitter -> this.client.summarizeIndicators(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

