/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.tenantmanagercontrolplane;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.DomainAsyncClient;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListDomainsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateDomainResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteDomainResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetDomainResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListDomainsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateDomainResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={DomainAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DomainRxClient {
    DomainAsyncClient client;

    DomainRxClient(DomainAsyncClient client) {
        this.client = client;
    }

    public Single<CreateDomainResponse> createDomain(CreateDomainRequest request) {
        return Single.create(emitter -> this.client.createDomain(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteDomainResponse> deleteDomain(DeleteDomainRequest request) {
        return Single.create(emitter -> this.client.deleteDomain(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetDomainResponse> getDomain(GetDomainRequest request) {
        return Single.create(emitter -> this.client.getDomain(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListDomainsResponse> listDomains(ListDomainsRequest request) {
        return Single.create(emitter -> this.client.listDomains(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateDomainResponse> updateDomain(UpdateDomainRequest request) {
        return Single.create(emitter -> this.client.updateDomain(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

