/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.servicemanagerproxy;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.servicemanagerproxy.ServiceManagerProxyAsyncClient;
import com.oracle.bmc.servicemanagerproxy.requests.GetServiceEnvironmentRequest;
import com.oracle.bmc.servicemanagerproxy.requests.ListServiceEnvironmentsRequest;
import com.oracle.bmc.servicemanagerproxy.responses.GetServiceEnvironmentResponse;
import com.oracle.bmc.servicemanagerproxy.responses.ListServiceEnvironmentsResponse;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ServiceManagerProxyAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ServiceManagerProxyRxClient {
    ServiceManagerProxyAsyncClient client;

    ServiceManagerProxyRxClient(ServiceManagerProxyAsyncClient client) {
        this.client = client;
    }

    public Single<GetServiceEnvironmentResponse> getServiceEnvironment(GetServiceEnvironmentRequest request) {
        return Single.create(emitter -> this.client.getServiceEnvironment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListServiceEnvironmentsResponse> listServiceEnvironments(ListServiceEnvironmentsRequest request) {
        return Single.create(emitter -> this.client.listServiceEnvironments(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

