/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.resourcescheduler;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.resourcescheduler.ScheduleAsyncClient;
import com.oracle.bmc.resourcescheduler.requests.ActivateScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.CancelWorkRequestRequest;
import com.oracle.bmc.resourcescheduler.requests.ChangeScheduleCompartmentRequest;
import com.oracle.bmc.resourcescheduler.requests.CreateScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.DeactivateScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.DeleteScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.GetScheduleRequest;
import com.oracle.bmc.resourcescheduler.requests.GetWorkRequestRequest;
import com.oracle.bmc.resourcescheduler.requests.ListResourceTypesRequest;
import com.oracle.bmc.resourcescheduler.requests.ListSchedulesRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.resourcescheduler.requests.ListWorkRequestsRequest;
import com.oracle.bmc.resourcescheduler.requests.UpdateScheduleRequest;
import com.oracle.bmc.resourcescheduler.responses.ActivateScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.CancelWorkRequestResponse;
import com.oracle.bmc.resourcescheduler.responses.ChangeScheduleCompartmentResponse;
import com.oracle.bmc.resourcescheduler.responses.CreateScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.DeactivateScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.DeleteScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.GetScheduleResponse;
import com.oracle.bmc.resourcescheduler.responses.GetWorkRequestResponse;
import com.oracle.bmc.resourcescheduler.responses.ListResourceTypesResponse;
import com.oracle.bmc.resourcescheduler.responses.ListSchedulesResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.resourcescheduler.responses.ListWorkRequestsResponse;
import com.oracle.bmc.resourcescheduler.responses.UpdateScheduleResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={ScheduleAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class ScheduleRxClient {
    ScheduleAsyncClient client;

    ScheduleRxClient(ScheduleAsyncClient client) {
        this.client = client;
    }

    public Single<ActivateScheduleResponse> activateSchedule(ActivateScheduleRequest request) {
        return Single.create(emitter -> this.client.activateSchedule(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request) {
        return Single.create(emitter -> this.client.cancelWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ChangeScheduleCompartmentResponse> changeScheduleCompartment(ChangeScheduleCompartmentRequest request) {
        return Single.create(emitter -> this.client.changeScheduleCompartment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateScheduleResponse> createSchedule(CreateScheduleRequest request) {
        return Single.create(emitter -> this.client.createSchedule(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeactivateScheduleResponse> deactivateSchedule(DeactivateScheduleRequest request) {
        return Single.create(emitter -> this.client.deactivateSchedule(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteScheduleResponse> deleteSchedule(DeleteScheduleRequest request) {
        return Single.create(emitter -> this.client.deleteSchedule(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetScheduleResponse> getSchedule(GetScheduleRequest request) {
        return Single.create(emitter -> this.client.getSchedule(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request) {
        return Single.create(emitter -> this.client.getWorkRequest(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListResourceTypesResponse> listResourceTypes(ListResourceTypesRequest request) {
        return Single.create(emitter -> this.client.listResourceTypes(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListSchedulesResponse> listSchedules(ListSchedulesRequest request) {
        return Single.create(emitter -> this.client.listSchedules(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestErrors(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequestLogs(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request) {
        return Single.create(emitter -> this.client.listWorkRequests(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateScheduleResponse> updateSchedule(UpdateScheduleRequest request) {
        return Single.create(emitter -> this.client.updateSchedule(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

