/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.queue;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.queue.QueueAsyncClient;
import com.oracle.bmc.queue.requests.DeleteMessageRequest;
import com.oracle.bmc.queue.requests.DeleteMessagesRequest;
import com.oracle.bmc.queue.requests.GetMessagesRequest;
import com.oracle.bmc.queue.requests.GetStatsRequest;
import com.oracle.bmc.queue.requests.ListChannelsRequest;
import com.oracle.bmc.queue.requests.PutMessagesRequest;
import com.oracle.bmc.queue.requests.UpdateMessageRequest;
import com.oracle.bmc.queue.requests.UpdateMessagesRequest;
import com.oracle.bmc.queue.responses.DeleteMessageResponse;
import com.oracle.bmc.queue.responses.DeleteMessagesResponse;
import com.oracle.bmc.queue.responses.GetMessagesResponse;
import com.oracle.bmc.queue.responses.GetStatsResponse;
import com.oracle.bmc.queue.responses.ListChannelsResponse;
import com.oracle.bmc.queue.responses.PutMessagesResponse;
import com.oracle.bmc.queue.responses.UpdateMessageResponse;
import com.oracle.bmc.queue.responses.UpdateMessagesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={QueueAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class QueueRxClient {
    QueueAsyncClient client;

    QueueRxClient(QueueAsyncClient client) {
        this.client = client;
    }

    public Single<DeleteMessageResponse> deleteMessage(DeleteMessageRequest request) {
        return Single.create(emitter -> this.client.deleteMessage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteMessagesResponse> deleteMessages(DeleteMessagesRequest request) {
        return Single.create(emitter -> this.client.deleteMessages(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetMessagesResponse> getMessages(GetMessagesRequest request) {
        return Single.create(emitter -> this.client.getMessages(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetStatsResponse> getStats(GetStatsRequest request) {
        return Single.create(emitter -> this.client.getStats(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListChannelsResponse> listChannels(ListChannelsRequest request) {
        return Single.create(emitter -> this.client.listChannels(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<PutMessagesResponse> putMessages(PutMessagesRequest request) {
        return Single.create(emitter -> this.client.putMessages(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateMessageResponse> updateMessage(UpdateMessageRequest request) {
        return Single.create(emitter -> this.client.updateMessage(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateMessagesResponse> updateMessages(UpdateMessagesRequest request) {
        return Single.create(emitter -> this.client.updateMessages(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

