/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.osubsubscription;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.osubsubscription.CommitmentAsyncClient;
import com.oracle.bmc.osubsubscription.requests.GetCommitmentRequest;
import com.oracle.bmc.osubsubscription.requests.ListCommitmentsRequest;
import com.oracle.bmc.osubsubscription.responses.GetCommitmentResponse;
import com.oracle.bmc.osubsubscription.responses.ListCommitmentsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={CommitmentAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class CommitmentRxClient {
    CommitmentAsyncClient client;

    CommitmentRxClient(CommitmentAsyncClient client) {
        this.client = client;
    }

    public Single<GetCommitmentResponse> getCommitment(GetCommitmentRequest request) {
        return Single.create(emitter -> this.client.getCommitment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListCommitmentsResponse> listCommitments(ListCommitmentsRequest request) {
        return Single.create(emitter -> this.client.listCommitments(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

