/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.ospgateway;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.ospgateway.InvoiceServiceAsyncClient;
import com.oracle.bmc.ospgateway.requests.DownloadPdfContentRequest;
import com.oracle.bmc.ospgateway.requests.GetInvoiceRequest;
import com.oracle.bmc.ospgateway.requests.ListInvoiceLinesRequest;
import com.oracle.bmc.ospgateway.requests.ListInvoicesRequest;
import com.oracle.bmc.ospgateway.requests.PayInvoiceRequest;
import com.oracle.bmc.ospgateway.responses.DownloadPdfContentResponse;
import com.oracle.bmc.ospgateway.responses.GetInvoiceResponse;
import com.oracle.bmc.ospgateway.responses.ListInvoiceLinesResponse;
import com.oracle.bmc.ospgateway.responses.ListInvoicesResponse;
import com.oracle.bmc.ospgateway.responses.PayInvoiceResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={InvoiceServiceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class InvoiceServiceRxClient {
    InvoiceServiceAsyncClient client;

    InvoiceServiceRxClient(InvoiceServiceAsyncClient client) {
        this.client = client;
    }

    public Single<DownloadPdfContentResponse> downloadPdfContent(DownloadPdfContentRequest request) {
        return Single.create(emitter -> this.client.downloadPdfContent(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetInvoiceResponse> getInvoice(GetInvoiceRequest request) {
        return Single.create(emitter -> this.client.getInvoice(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListInvoiceLinesResponse> listInvoiceLines(ListInvoiceLinesRequest request) {
        return Single.create(emitter -> this.client.listInvoiceLines(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListInvoicesResponse> listInvoices(ListInvoicesRequest request) {
        return Single.create(emitter -> this.client.listInvoices(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<PayInvoiceResponse> payInvoice(PayInvoiceRequest request) {
        return Single.create(emitter -> this.client.payInvoice(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

