/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.ospgateway;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.ospgateway.AddressServiceAsyncClient;
import com.oracle.bmc.ospgateway.requests.GetAddressRequest;
import com.oracle.bmc.ospgateway.requests.VerifyAddressRequest;
import com.oracle.bmc.ospgateway.responses.GetAddressResponse;
import com.oracle.bmc.ospgateway.responses.VerifyAddressResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={AddressServiceAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AddressServiceRxClient {
    AddressServiceAsyncClient client;

    AddressServiceRxClient(AddressServiceAsyncClient client) {
        this.client = client;
    }

    public Single<GetAddressResponse> getAddress(GetAddressRequest request) {
        return Single.create(emitter -> this.client.getAddress(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<VerifyAddressResponse> verifyAddress(VerifyAddressRequest request) {
        return Single.create(emitter -> this.client.verifyAddress(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

