/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.operatoraccesscontrol;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.operatoraccesscontrol.OperatorActionsAsyncClient;
import com.oracle.bmc.operatoraccesscontrol.requests.GetOperatorActionRequest;
import com.oracle.bmc.operatoraccesscontrol.requests.ListOperatorActionsRequest;
import com.oracle.bmc.operatoraccesscontrol.responses.GetOperatorActionResponse;
import com.oracle.bmc.operatoraccesscontrol.responses.ListOperatorActionsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={OperatorActionsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OperatorActionsRxClient {
    OperatorActionsAsyncClient client;

    OperatorActionsRxClient(OperatorActionsAsyncClient client) {
        this.client = client;
    }

    public Single<GetOperatorActionResponse> getOperatorAction(GetOperatorActionRequest request) {
        return Single.create(emitter -> this.client.getOperatorAction(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListOperatorActionsResponse> listOperatorActions(ListOperatorActionsRequest request) {
        return Single.create(emitter -> this.client.listOperatorActions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

