/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.ocvp;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.ocvp.EsxiHostAsyncClient;
import com.oracle.bmc.ocvp.requests.CreateEsxiHostRequest;
import com.oracle.bmc.ocvp.requests.DeleteEsxiHostRequest;
import com.oracle.bmc.ocvp.requests.GetEsxiHostRequest;
import com.oracle.bmc.ocvp.requests.InplaceUpgradeRequest;
import com.oracle.bmc.ocvp.requests.ListEsxiHostsRequest;
import com.oracle.bmc.ocvp.requests.ReplaceHostRequest;
import com.oracle.bmc.ocvp.requests.SwapBillingRequest;
import com.oracle.bmc.ocvp.requests.UpdateEsxiHostRequest;
import com.oracle.bmc.ocvp.responses.CreateEsxiHostResponse;
import com.oracle.bmc.ocvp.responses.DeleteEsxiHostResponse;
import com.oracle.bmc.ocvp.responses.GetEsxiHostResponse;
import com.oracle.bmc.ocvp.responses.InplaceUpgradeResponse;
import com.oracle.bmc.ocvp.responses.ListEsxiHostsResponse;
import com.oracle.bmc.ocvp.responses.ReplaceHostResponse;
import com.oracle.bmc.ocvp.responses.SwapBillingResponse;
import com.oracle.bmc.ocvp.responses.UpdateEsxiHostResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={EsxiHostAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class EsxiHostRxClient {
    EsxiHostAsyncClient client;

    EsxiHostRxClient(EsxiHostAsyncClient client) {
        this.client = client;
    }

    public Single<CreateEsxiHostResponse> createEsxiHost(CreateEsxiHostRequest request) {
        return Single.create(emitter -> this.client.createEsxiHost(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteEsxiHostResponse> deleteEsxiHost(DeleteEsxiHostRequest request) {
        return Single.create(emitter -> this.client.deleteEsxiHost(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetEsxiHostResponse> getEsxiHost(GetEsxiHostRequest request) {
        return Single.create(emitter -> this.client.getEsxiHost(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<InplaceUpgradeResponse> inplaceUpgrade(InplaceUpgradeRequest request) {
        return Single.create(emitter -> this.client.inplaceUpgrade(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListEsxiHostsResponse> listEsxiHosts(ListEsxiHostsRequest request) {
        return Single.create(emitter -> this.client.listEsxiHosts(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ReplaceHostResponse> replaceHost(ReplaceHostRequest request) {
        return Single.create(emitter -> this.client.replaceHost(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SwapBillingResponse> swapBilling(SwapBillingRequest request) {
        return Single.create(emitter -> this.client.swapBilling(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateEsxiHostResponse> updateEsxiHost(UpdateEsxiHostRequest request) {
        return Single.create(emitter -> this.client.updateEsxiHost(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

