/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.marketplacepublisher;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.marketplacepublisher.OfferAsyncClient;
import com.oracle.bmc.marketplacepublisher.requests.CreateOfferRequest;
import com.oracle.bmc.marketplacepublisher.requests.DeleteOfferRequest;
import com.oracle.bmc.marketplacepublisher.requests.GetOfferInternalDetailRequest;
import com.oracle.bmc.marketplacepublisher.requests.GetOfferRequest;
import com.oracle.bmc.marketplacepublisher.requests.ListOffersRequest;
import com.oracle.bmc.marketplacepublisher.requests.UpdateOfferRequest;
import com.oracle.bmc.marketplacepublisher.responses.CreateOfferResponse;
import com.oracle.bmc.marketplacepublisher.responses.DeleteOfferResponse;
import com.oracle.bmc.marketplacepublisher.responses.GetOfferInternalDetailResponse;
import com.oracle.bmc.marketplacepublisher.responses.GetOfferResponse;
import com.oracle.bmc.marketplacepublisher.responses.ListOffersResponse;
import com.oracle.bmc.marketplacepublisher.responses.UpdateOfferResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={OfferAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class OfferRxClient {
    OfferAsyncClient client;

    OfferRxClient(OfferAsyncClient client) {
        this.client = client;
    }

    public Single<CreateOfferResponse> createOffer(CreateOfferRequest request) {
        return Single.create(emitter -> this.client.createOffer(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteOfferResponse> deleteOffer(DeleteOfferRequest request) {
        return Single.create(emitter -> this.client.deleteOffer(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetOfferResponse> getOffer(GetOfferRequest request) {
        return Single.create(emitter -> this.client.getOffer(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetOfferInternalDetailResponse> getOfferInternalDetail(GetOfferInternalDetailRequest request) {
        return Single.create(emitter -> this.client.getOfferInternalDetail(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListOffersResponse> listOffers(ListOffersRequest request) {
        return Single.create(emitter -> this.client.listOffers(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateOfferResponse> updateOffer(UpdateOfferRequest request) {
        return Single.create(emitter -> this.client.updateOffer(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

