/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.marketplacepublisher;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.marketplacepublisher.AttachmentAsyncClient;
import com.oracle.bmc.marketplacepublisher.requests.CreateAttachmentRequest;
import com.oracle.bmc.marketplacepublisher.requests.DeleteAttachmentRequest;
import com.oracle.bmc.marketplacepublisher.requests.GetAttachmentContentRequest;
import com.oracle.bmc.marketplacepublisher.requests.GetAttachmentRequest;
import com.oracle.bmc.marketplacepublisher.requests.ListAttachmentsRequest;
import com.oracle.bmc.marketplacepublisher.responses.CreateAttachmentResponse;
import com.oracle.bmc.marketplacepublisher.responses.DeleteAttachmentResponse;
import com.oracle.bmc.marketplacepublisher.responses.GetAttachmentContentResponse;
import com.oracle.bmc.marketplacepublisher.responses.GetAttachmentResponse;
import com.oracle.bmc.marketplacepublisher.responses.ListAttachmentsResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={AttachmentAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class AttachmentRxClient {
    AttachmentAsyncClient client;

    AttachmentRxClient(AttachmentAsyncClient client) {
        this.client = client;
    }

    public Single<CreateAttachmentResponse> createAttachment(CreateAttachmentRequest request) {
        return Single.create(emitter -> this.client.createAttachment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteAttachmentResponse> deleteAttachment(DeleteAttachmentRequest request) {
        return Single.create(emitter -> this.client.deleteAttachment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAttachmentResponse> getAttachment(GetAttachmentRequest request) {
        return Single.create(emitter -> this.client.getAttachment(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetAttachmentContentResponse> getAttachmentContent(GetAttachmentContentRequest request) {
        return Single.create(emitter -> this.client.getAttachmentContent(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListAttachmentsResponse> listAttachments(ListAttachmentsRequest request) {
        return Single.create(emitter -> this.client.listAttachments(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

