/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.limits;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.limits.LimitsAsyncClient;
import com.oracle.bmc.limits.requests.GetResourceAvailabilityRequest;
import com.oracle.bmc.limits.requests.ListLimitDefinitionsRequest;
import com.oracle.bmc.limits.requests.ListLimitValuesRequest;
import com.oracle.bmc.limits.requests.ListServicesRequest;
import com.oracle.bmc.limits.responses.GetResourceAvailabilityResponse;
import com.oracle.bmc.limits.responses.ListLimitDefinitionsResponse;
import com.oracle.bmc.limits.responses.ListLimitValuesResponse;
import com.oracle.bmc.limits.responses.ListServicesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={LimitsAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class LimitsRxClient {
    LimitsAsyncClient client;

    LimitsRxClient(LimitsAsyncClient client) {
        this.client = client;
    }

    public Single<GetResourceAvailabilityResponse> getResourceAvailability(GetResourceAvailabilityRequest request) {
        return Single.create(emitter -> this.client.getResourceAvailability(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListLimitDefinitionsResponse> listLimitDefinitions(ListLimitDefinitionsRequest request) {
        return Single.create(emitter -> this.client.listLimitDefinitions(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListLimitValuesResponse> listLimitValues(ListLimitValuesRequest request) {
        return Single.create(emitter -> this.client.listLimitValues(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListServicesResponse> listServices(ListServicesRequest request) {
        return Single.create(emitter -> this.client.listServices(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

