/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.keymanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.KmsCryptoAsyncClient;
import com.oracle.bmc.keymanagement.requests.DecryptRequest;
import com.oracle.bmc.keymanagement.requests.EncryptRequest;
import com.oracle.bmc.keymanagement.requests.ExportKeyRequest;
import com.oracle.bmc.keymanagement.requests.GenerateDataEncryptionKeyRequest;
import com.oracle.bmc.keymanagement.requests.SignRequest;
import com.oracle.bmc.keymanagement.requests.VerifyRequest;
import com.oracle.bmc.keymanagement.responses.DecryptResponse;
import com.oracle.bmc.keymanagement.responses.EncryptResponse;
import com.oracle.bmc.keymanagement.responses.ExportKeyResponse;
import com.oracle.bmc.keymanagement.responses.GenerateDataEncryptionKeyResponse;
import com.oracle.bmc.keymanagement.responses.SignResponse;
import com.oracle.bmc.keymanagement.responses.VerifyResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={KmsCryptoAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class KmsCryptoRxClient {
    KmsCryptoAsyncClient client;

    KmsCryptoRxClient(KmsCryptoAsyncClient client) {
        this.client = client;
    }

    public Single<DecryptResponse> decrypt(DecryptRequest request) {
        return Single.create(emitter -> this.client.decrypt(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<EncryptResponse> encrypt(EncryptRequest request) {
        return Single.create(emitter -> this.client.encrypt(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ExportKeyResponse> exportKey(ExportKeyRequest request) {
        return Single.create(emitter -> this.client.exportKey(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GenerateDataEncryptionKeyResponse> generateDataEncryptionKey(GenerateDataEncryptionKeyRequest request) {
        return Single.create(emitter -> this.client.generateDataEncryptionKey(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<SignResponse> sign(SignRequest request) {
        return Single.create(emitter -> this.client.sign(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<VerifyResponse> verify(VerifyRequest request) {
        return Single.create(emitter -> this.client.verify(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

