/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.keymanagement;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.EkmAsyncClient;
import com.oracle.bmc.keymanagement.requests.CreateEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.DeleteEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.GetEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.ListEkmsPrivateEndpointsRequest;
import com.oracle.bmc.keymanagement.requests.UpdateEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.responses.CreateEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.DeleteEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.GetEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.ListEkmsPrivateEndpointsResponse;
import com.oracle.bmc.keymanagement.responses.UpdateEkmsPrivateEndpointResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={EkmAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class EkmRxClient {
    EkmAsyncClient client;

    EkmRxClient(EkmAsyncClient client) {
        this.client = client;
    }

    public Single<CreateEkmsPrivateEndpointResponse> createEkmsPrivateEndpoint(CreateEkmsPrivateEndpointRequest request) {
        return Single.create(emitter -> this.client.createEkmsPrivateEndpoint(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteEkmsPrivateEndpointResponse> deleteEkmsPrivateEndpoint(DeleteEkmsPrivateEndpointRequest request) {
        return Single.create(emitter -> this.client.deleteEkmsPrivateEndpoint(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetEkmsPrivateEndpointResponse> getEkmsPrivateEndpoint(GetEkmsPrivateEndpointRequest request) {
        return Single.create(emitter -> this.client.getEkmsPrivateEndpoint(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListEkmsPrivateEndpointsResponse> listEkmsPrivateEndpoints(ListEkmsPrivateEndpointsRequest request) {
        return Single.create(emitter -> this.client.listEkmsPrivateEndpoints(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateEkmsPrivateEndpointResponse> updateEkmsPrivateEndpoint(UpdateEkmsPrivateEndpointRequest request) {
        return Single.create(emitter -> this.client.updateEkmsPrivateEndpoint(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

