/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.oraclecloud.clients.rxjava2.dashboardservice;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.dashboardservice.DashboardAsyncClient;
import com.oracle.bmc.dashboardservice.requests.ChangeDashboardGroupRequest;
import com.oracle.bmc.dashboardservice.requests.CreateDashboardRequest;
import com.oracle.bmc.dashboardservice.requests.DeleteDashboardRequest;
import com.oracle.bmc.dashboardservice.requests.GetDashboardRequest;
import com.oracle.bmc.dashboardservice.requests.ListDashboardsRequest;
import com.oracle.bmc.dashboardservice.requests.UpdateDashboardRequest;
import com.oracle.bmc.dashboardservice.responses.ChangeDashboardGroupResponse;
import com.oracle.bmc.dashboardservice.responses.CreateDashboardResponse;
import com.oracle.bmc.dashboardservice.responses.DeleteDashboardResponse;
import com.oracle.bmc.dashboardservice.responses.GetDashboardResponse;
import com.oracle.bmc.dashboardservice.responses.ListDashboardsResponse;
import com.oracle.bmc.dashboardservice.responses.UpdateDashboardResponse;
import com.oracle.bmc.responses.AsyncHandler;
import io.micronaut.context.annotation.Requires;
import io.micronaut.oraclecloud.clients.rxjava2.AsyncHandlerEmitter;
import io.reactivex.Single;
import jakarta.inject.Singleton;

@Requires(classes={DashboardAsyncClient.class, Single.class}, beans={AbstractAuthenticationDetailsProvider.class})
@Singleton
public class DashboardRxClient {
    DashboardAsyncClient client;

    DashboardRxClient(DashboardAsyncClient client) {
        this.client = client;
    }

    public Single<ChangeDashboardGroupResponse> changeDashboardGroup(ChangeDashboardGroupRequest request) {
        return Single.create(emitter -> this.client.changeDashboardGroup(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<CreateDashboardResponse> createDashboard(CreateDashboardRequest request) {
        return Single.create(emitter -> this.client.createDashboard(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<DeleteDashboardResponse> deleteDashboard(DeleteDashboardRequest request) {
        return Single.create(emitter -> this.client.deleteDashboard(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<GetDashboardResponse> getDashboard(GetDashboardRequest request) {
        return Single.create(emitter -> this.client.getDashboard(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<ListDashboardsResponse> listDashboards(ListDashboardsRequest request) {
        return Single.create(emitter -> this.client.listDashboards(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }

    public Single<UpdateDashboardResponse> updateDashboard(UpdateDashboardRequest request) {
        return Single.create(emitter -> this.client.updateDashboard(request, (AsyncHandler)new AsyncHandlerEmitter(emitter)));
    }
}

